/*
 * Decompiled with CFR 0.152.
 */
package abo;

import abo.ABOConfiguration;
import abo.ItemIconProvider;
import abo.PipeIconProvider;
import abo.actions.ABOActionProvider;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import abo.gui.ABOGuiHandler;
import abo.items.ItemGateSettingsDuplicator;
import abo.network.ABOPacketHandler;
import abo.pipes.items.PipeItemsBounce;
import abo.pipes.items.PipeItemsCompactor;
import abo.pipes.items.PipeItemsCrossover;
import abo.pipes.items.PipeItemsExtraction;
import abo.pipes.items.PipeItemsInsertion;
import abo.pipes.items.PipeItemsRoundRobin;
import abo.pipes.items.PipeItemsStripes;
import abo.pipes.liquids.PipeLiquidsBalance;
import abo.pipes.liquids.PipeLiquidsDiamond;
import abo.pipes.liquids.PipeLiquidsGoldenIron;
import abo.pipes.liquids.PipeLiquidsPump;
import abo.pipes.liquids.PipeLiquidsValve;
import abo.pipes.power.PipePowerDiamond;
import abo.pipes.power.PipePowerIron;
import abo.pipes.power.PipePowerSwitch;
import abo.proxy.ABOProxy;
import abo.triggers.ABOTriggerProvider;
import abo.triggers.TriggerEngineSafe;
import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionProvider;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.core.utils.Localization;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.blueprints.BptItemPipeDiamond;
import buildcraft.transport.blueprints.BptItemPipeIron;
import buildcraft.transport.blueprints.BptItemPipeWooden;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Property;

@Mod(modid="Additional-Buildcraft-Objects", name="Additional-Buildcraft-Objects", version="1.0.3.144", dependencies="required-after:Forge@7.7.2.682,);required-after:BuildCraft|Transport;required-after:BuildCraft|Energy")
@NetworkMod(channels={"ABO"}, packetHandler=ABOPacketHandler.class)
public class ABO {
    public static final String VERSION = "1.0.3.144";
    public IIconProvider itemIconProvider = new ItemIconProvider();
    public IIconProvider pipeIconProvider = new PipeIconProvider();
    public static ABOConfiguration aboConfiguration;
    public static Logger aboLog;
    public static int itemGateSettingsDuplicatorID;
    public static Item itemGateSettingsDuplicator;
    public static int pipeLiquidsValveID;
    public static Item pipeLiquidsValve;
    public static int pipeLiquidsGoldenIronID;
    public static Item pipeLiquidsGoldenIron;
    public static int pipeLiquidsBalanceID;
    public static Item pipeLiquidsBalance;
    public static int pipeLiquidsDiamondID;
    public static Item pipeLiquidsDiamond;
    public static int pipeLiquidsWaterPumpID;
    public static Item pipeLiquidsWaterPump;
    public static int pipeItemsRoundRobinID;
    public static Item pipeItemsRoundRobin;
    public static int pipeItemsCompactorID;
    public static Item pipeItemsCompactor;
    public static int pipeItemsInsertionID;
    public static Item pipeItemsInsertion;
    public static int pipeItemsExtractionID;
    public static Item pipeItemsExtraction;
    public static int pipeItemsBounceID;
    public static Item pipeItemsBounce;
    public static int pipeItemsCrossoverID;
    public static Item pipeItemsCrossover;
    public static int pipeItemsStripesID;
    public static Item pipeItemsStripes;
    public static int pipePowerSwitchID;
    public static Item pipePowerSwitch;
    public static int pipePowerIronID;
    public static Item pipePowerIron;
    public static int pipeDiamondConductiveID;
    public static Item pipeDiamondConductive;
    public static int triggerEngineSafeID;
    public static ITrigger triggerEngineSafe;
    public static int actionSwitchOnPipeID;
    public static IAction actionSwitchOnPipe;
    public static int actionToggleOnPipeID;
    public static IAction actionToggleOnPipe;
    public static int actionToggleOffPipeID;
    public static IAction actionToggleOffPipe;
    @Mod.Instance(value="Additional-Buildcraft-Objects")
    public static ABO instance;
    private static LinkedList aboRecipes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void preInitialize(FMLPreInitializationEvent evt) {
        aboLog.setParent(FMLLog.getLogger());
        aboLog.info("Starting Additional-Buildcraft-Objects #144 1.0.3.144 (Built for Minecraft 1.5.2 with Buildcraft 3.5.3 and Forge 7.8.0.684");
        aboLog.info("Copyright (c) Flow86, 2011-2013");
        aboConfiguration = new ABOConfiguration(new File(evt.getModConfigurationDirectory(), "abo/main.conf"));
        try {
            aboConfiguration.load();
            itemGateSettingsDuplicator = ABO.createItem(itemGateSettingsDuplicatorID, ItemGateSettingsDuplicator.class, "Gate Settings Duplicator", BuildCraftCore.wrenchItem, BuildCraftTransport.pipeGateAutarchic, null);
            pipeLiquidsValve = ABO.createPipe(pipeLiquidsValveID, PipeLiquidsValve.class, "Valve Pipe", 1, BuildCraftTransport.pipeLiquidsWood, BuildCraftTransport.pipeGateAutarchic, null);
            pipeLiquidsGoldenIron = ABO.createPipe(pipeLiquidsGoldenIronID, PipeLiquidsGoldenIron.class, "Golden Iron Waterproof Pipe", 1, BuildCraftTransport.pipeLiquidsGold, BuildCraftTransport.pipeLiquidsIron, null);
            pipeLiquidsBalance = ABO.createPipe(pipeLiquidsBalanceID, PipeLiquidsBalance.class, "Balancing Waterproof Pipe", 1, BuildCraftTransport.pipeLiquidsWood, new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 0), BuildCraftTransport.pipeLiquidsWood);
            pipeLiquidsDiamond = ABO.createPipe(pipeLiquidsDiamondID, PipeLiquidsDiamond.class, "Diamond Waterproof Pipe", 1, BuildCraftTransport.pipeItemsDiamond, BuildCraftTransport.pipeWaterproof, null);
            if (GameRegistry.findItem((String)"APUnofficial", (String)"item.PipeLiquidsWaterPump") == null) {
                pipeLiquidsWaterPump = ABO.createPipe(pipeLiquidsWaterPumpID, PipeLiquidsPump.class, "Water Pump Pipe", 1, false, new Object[]{" L ", "rPr", " W ", Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('P'), BuildCraftCore.ironGearItem, Character.valueOf('L'), BuildCraftTransport.pipeLiquidsGold, Character.valueOf('W'), BuildCraftTransport.pipeLiquidsWood});
            }
            pipeItemsRoundRobin = ABO.createPipe(pipeItemsRoundRobinID, PipeItemsRoundRobin.class, "RoundRobin Transport Pipe", 1, BuildCraftTransport.pipeItemsStone, Block.field_71940_F, null);
            pipeItemsCompactor = ABO.createPipe(pipeItemsCompactorID, PipeItemsCompactor.class, "Compactor Pipe", 1, BuildCraftTransport.pipeItemsStone, Block.field_71963_Z, null);
            pipeItemsInsertion = ABO.createPipe(pipeItemsInsertionID, PipeItemsInsertion.class, "Insertion Pipe", 1, BuildCraftTransport.pipeItemsCobblestone, Item.field_77767_aC, null);
            pipeItemsExtraction = ABO.createPipe(pipeItemsExtractionID, PipeItemsExtraction.class, "Extraction Transport Pipe", 1, BuildCraftTransport.pipeItemsWood, Block.field_71988_x, null);
            pipeItemsBounce = ABO.createPipe(pipeItemsBounceID, PipeItemsBounce.class, "Bounce Transport Pipe", 1, BuildCraftTransport.pipeItemsStone, Block.field_71978_w, null);
            pipeItemsCrossover = ABO.createPipe(pipeItemsCrossoverID, PipeItemsCrossover.class, "Crossover Transport Pipe", 1, BuildCraftTransport.pipeItemsStone, BuildCraftTransport.pipeItemsIron, null);
            pipeItemsStripes = ABO.createPipe(pipeItemsStripesID, PipeItemsStripes.class, "Stripes Transport Pipe", 8, new ItemStack(Item.field_77756_aW, 1, 0), Block.field_71946_M, new ItemStack(Item.field_77756_aW, 1, 11));
            pipePowerSwitch = ABO.createPipe(pipePowerSwitchID, PipePowerSwitch.class, "Power Switch Pipe", 1, BuildCraftTransport.pipePowerGold, Block.field_72043_aJ, null);
            pipePowerIron = ABO.createPipe(pipePowerIronID, PipePowerIron.class, "Iron Power Pipe", 1, Item.field_77767_aC, BuildCraftTransport.pipeItemsIron, null);
            pipeDiamondConductive = ABO.createPipe(pipeDiamondConductiveID, PipePowerDiamond.class, "Diamond Conductive Pipe", 1, Item.field_77767_aC, BuildCraftTransport.pipeItemsDiamond, null);
            triggerEngineSafe = new TriggerEngineSafe(triggerEngineSafeID);
            actionSwitchOnPipe = new ActionSwitchOnPipe(actionSwitchOnPipeID);
            actionToggleOnPipe = new ActionToggleOnPipe(actionToggleOnPipeID);
            actionToggleOffPipe = new ActionToggleOffPipe(actionToggleOffPipeID);
            ActionManager.registerActionProvider((IActionProvider)new ABOActionProvider());
            ActionManager.registerTriggerProvider((ITriggerProvider)new ABOTriggerProvider());
            BuildCraftCore.itemBptProps[ABO.pipeItemsExtraction.field_77779_bT] = new BptItemPipeWooden();
            BuildCraftCore.itemBptProps[ABO.pipeLiquidsValve.field_77779_bT] = new BptItemPipeIron();
            BuildCraftCore.itemBptProps[ABO.pipeLiquidsGoldenIron.field_77779_bT] = new BptItemPipeIron();
            BuildCraftCore.itemBptProps[ABO.pipeLiquidsDiamond.field_77779_bT] = new BptItemPipeDiamond();
            BuildCraftCore.itemBptProps[ABO.pipePowerIron.field_77779_bT] = new BptItemPipeIron();
        }
        finally {
            if (aboConfiguration.hasChanged()) {
                aboConfiguration.save();
            }
        }
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        Localization.addLocalization((String)"/lang/abo/", (String)"en_US");
        ABORecipe recipe = new ABORecipe();
        recipe.itemID = ABO.pipeLiquidsValve.field_77779_bT;
        recipe.isShapeless = true;
        recipe.result = new ItemStack(pipeLiquidsValve, 1);
        recipe.input = new Object[]{BuildCraftTransport.pipeLiquidsWood, BuildCraftTransport.pipeGateAutarchic};
        aboRecipes.add(recipe);
        this.loadRecipes();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new ABOGuiHandler());
    }

    private static Item createItem(int defaultID, Class clazz, String descr, Object ingredient1, Object ingredient2, Object ingredient3) {
        int id;
        String name = Character.toLowerCase(clazz.getSimpleName().charAt(0)) + clazz.getSimpleName().substring(1);
        Property prop = aboConfiguration.getItem(name + ".id", defaultID);
        for (id = prop.getInt(defaultID); id < Item.field_77698_e.length && Item.field_77698_e[id] != null; ++id) {
        }
        if (id >= Item.field_77698_e.length) {
            aboLog.log(Level.SEVERE, "Cannot find free ID for Item + " + name + " starting from " + defaultID);
            return null;
        }
        prop.set(id);
        Item item = null;
        try {
            item = (Item)clazz.getConstructor(Integer.TYPE).newInstance(id);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (item == null) {
            return item;
        }
        item.func_77655_b(clazz.getSimpleName());
        LanguageRegistry.addName(item, (String)descr);
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a().replace("item.", ""));
        ABO.addReceipe(item, 1, ingredient1, ingredient2, ingredient3);
        return item;
    }

    private static void addReceipe(Item item, int count, Object ingredient1, Object ingredient2, Object ingredient3) {
        if (ingredient1 != null && ingredient2 != null && ingredient3 != null) {
            ABO.addReceipe(item, count, false, new Object[]{"ABC", Character.valueOf('A'), ingredient1, Character.valueOf('B'), ingredient2, Character.valueOf('C'), ingredient3});
        } else if (ingredient1 != null && ingredient2 != null) {
            ABO.addReceipe(item, count, true, new Object[]{ingredient1, ingredient2});
        }
    }

    private static void addReceipe(Item item, int count, boolean isShapeless, Object[] ingredients) {
        ABORecipe recipe = new ABORecipe();
        recipe.isPipe = item instanceof ItemPipe;
        recipe.itemID = item.field_77779_bT;
        recipe.isShapeless = isShapeless;
        recipe.input = ingredients;
        recipe.result = new ItemStack(item, count);
        aboRecipes.add(recipe);
    }

    private static ItemPipe createPipe(int defaultID, Class clazz, String descr) {
        String name = Character.toLowerCase(clazz.getSimpleName().charAt(0)) + clazz.getSimpleName().substring(1);
        Property prop = aboConfiguration.getItem(name + ".id", defaultID);
        int id = prop.getInt(defaultID);
        try {
            while (BlockGenericPipe.isPipeRegistered((int)id)) {
                ++id;
            }
            prop.set(id);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        ItemPipe pipe = BlockGenericPipe.registerPipe((int)id, (Class)clazz);
        pipe.func_77655_b(clazz.getSimpleName());
        LanguageRegistry.addName((Object)pipe, (String)descr);
        GameRegistry.registerItem((Item)pipe, (String)pipe.func_77658_a().replace("item.", ""));
        return pipe;
    }

    private static Item createPipe(int defaultID, Class clazz, String descr, int count, boolean isShapeless, Object[] ingredients) {
        ItemPipe pipe = ABO.createPipe(defaultID, clazz, descr);
        ABO.addReceipe((Item)pipe, count, isShapeless, ingredients);
        return pipe;
    }

    private static Item createPipe(int defaultID, Class clazz, String descr, int count, Object ingredient1, Object ingredient2, Object ingredient3) {
        ItemPipe pipe = ABO.createPipe(defaultID, clazz, descr);
        ABO.addReceipe((Item)pipe, count, ingredient1, ingredient2, ingredient3);
        return pipe;
    }

    public void loadRecipes() {
        for (ABORecipe recipe : aboRecipes) {
            if (recipe.isShapeless) {
                GameRegistry.addShapelessRecipe((ItemStack)recipe.result, (Object[])recipe.input);
            } else {
                GameRegistry.addRecipe((ItemStack)recipe.result, (Object[])recipe.input);
            }
            if (!recipe.isPipe) continue;
            ABOProxy.proxy.registerPipe(recipe.itemID);
        }
    }

    static {
        aboLog = Logger.getLogger("Additional-Buildcraft-Objects");
        itemGateSettingsDuplicatorID = 10100;
        itemGateSettingsDuplicator = null;
        pipeLiquidsValveID = 10200;
        pipeLiquidsValve = null;
        pipeLiquidsGoldenIronID = 10201;
        pipeLiquidsGoldenIron = null;
        pipeLiquidsBalanceID = 10203;
        pipeLiquidsBalance = null;
        pipeLiquidsDiamondID = 10204;
        pipeLiquidsDiamond = null;
        pipeLiquidsWaterPumpID = 14054;
        pipeLiquidsWaterPump = null;
        pipeItemsRoundRobinID = 10300;
        pipeItemsRoundRobin = null;
        pipeItemsCompactorID = 10301;
        pipeItemsCompactor = null;
        pipeItemsInsertionID = 10302;
        pipeItemsInsertion = null;
        pipeItemsExtractionID = 10303;
        pipeItemsExtraction = null;
        pipeItemsBounceID = 10304;
        pipeItemsBounce = null;
        pipeItemsCrossoverID = 10305;
        pipeItemsCrossover = null;
        pipeItemsStripesID = 4071;
        pipeItemsStripes = null;
        pipePowerSwitchID = 10400;
        pipePowerSwitch = null;
        pipePowerIronID = 10401;
        pipePowerIron = null;
        pipeDiamondConductiveID = 10402;
        pipeDiamondConductive = null;
        triggerEngineSafeID = 128;
        triggerEngineSafe = null;
        actionSwitchOnPipeID = 128;
        actionSwitchOnPipe = null;
        actionToggleOnPipeID = 129;
        actionToggleOnPipe = null;
        actionToggleOffPipeID = 130;
        actionToggleOffPipe = null;
        aboRecipes = new LinkedList();
    }

    private static class ABORecipe {
        int itemID;
        boolean isPipe = false;
        boolean isShapeless = false;
        ItemStack result;
        Object[] input;

        private ABORecipe() {
        }
    }
}

