/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.items;

import abo.ABO;
import abo.PipeIconProvider;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import abo.pipes.ABOPipe;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicStone;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsCompactor
extends ABOPipe
implements IPipeTransportItemsHook,
IActionReceptor {
    private final int onTexture = PipeIconProvider.PipeItemsCompactorOn;
    private final int offTexture = PipeIconProvider.PipeItemsCompactorOff;
    private boolean powered = false;
    private boolean toggled = false;
    private boolean switched = false;
    TreeMap items = new TreeMap();
    private final SafeTimeTracker timeTracker = new SafeTimeTracker();

    public PipeItemsCompactor(int itemID) {
        super((PipeTransport)new PipeTransportItems(), (PipeLogic)new PipeLogicStone(), itemID);
    }

    public void addItemToItemStack(ForgeDirection orientation, Integer itemID, Integer dmgID, Integer stackSize) {
        if (!this.items.containsKey(orientation)) {
            this.items.put(orientation, new TreeMap());
        }
        System.out.println("ItemID: " + itemID + "/" + dmgID + " - Size: " + stackSize);
        Pair key = new Pair(itemID, dmgID);
        if (!((TreeMap)this.items.get(orientation)).containsKey(key)) {
            ((TreeMap)this.items.get(orientation)).put(key, new ItemStacker(new ItemStack(itemID.intValue(), stackSize.intValue(), dmgID.intValue())));
        } else {
            ((ItemStacker)((TreeMap)this.items.get((Object)orientation)).get((Object)key)).itemStack.field_77994_a += stackSize.intValue();
        }
        System.out.println("New Size: " + ((ItemStacker)((TreeMap)this.items.get((Object)orientation)).get((Object)key)).itemStack.field_77994_a);
    }

    public void dropContents() {
        this.powered = false;
        this.toggled = false;
        this.switched = false;
        for (Map.Entry item : this.items.entrySet()) {
            for (Map.Entry itemStack : ((TreeMap)item.getValue()).entrySet()) {
                Utils.dropItems((World)this.worldObj, (ItemStack)((ItemStacker)itemStack.getValue()).itemStack, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord);
            }
        }
        this.items.clear();
        super.dropContents();
    }

    public void doWork() {
        System.out.println("doWork()");
        System.out.println("Output:");
        for (Map.Entry item : this.items.entrySet()) {
            LinkedList toRemove = new LinkedList();
            for (Map.Entry itemStack : ((TreeMap)item.getValue()).entrySet()) {
                boolean processed = false;
                while (((ItemStacker)itemStack.getValue()).itemStack.field_77994_a >= 16 || ((ItemStacker)itemStack.getValue()).underruns >= 5) {
                    processed = true;
                    ((ItemStacker)itemStack.getValue()).underruns = 0;
                    System.out.println(">>> itemStack(" + ((ItemStacker)itemStack.getValue()).underruns + "):" + item.getKey() + ", " + ((ItemStacker)itemStack.getValue()).itemStack.field_77993_c + " has " + ((ItemStacker)itemStack.getValue()).itemStack.field_77994_a);
                    int stackSize = ((ItemStacker)itemStack.getValue()).itemStack.field_77994_a;
                    if (((ItemStacker)itemStack.getValue()).itemStack.field_77994_a >= 16) {
                        stackSize = Math.min(64, ((ItemStacker)itemStack.getValue()).itemStack.field_77994_a);
                    }
                    System.out.println("Stacksize: " + stackSize);
                    System.out.println("Before: " + ((ItemStacker)itemStack.getValue()).itemStack.field_77994_a);
                    ItemStack output = ((ItemStacker)itemStack.getValue()).itemStack.func_77979_a(stackSize);
                    System.out.println("After: " + ((ItemStacker)itemStack.getValue()).itemStack.field_77994_a);
                    if (!Utils.addToRandomPipeEntry((TileEntity)this.container, (ForgeDirection)((ForgeDirection)item.getKey()), (ItemStack)output)) {
                        Position destPos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (ForgeDirection)item.getKey());
                        destPos.moveForwards(0.3);
                        Utils.dropItems((World)this.worldObj, (ItemStack)output, (int)((int)destPos.x), (int)((int)destPos.y), (int)((int)destPos.z));
                    }
                    if (((ItemStacker)itemStack.getValue()).itemStack.field_77994_a > 0) continue;
                    toRemove.add(itemStack.getValue());
                }
                if (processed) continue;
                ++((ItemStacker)itemStack.getValue()).underruns;
                System.out.println("=== itemStack(" + ((ItemStacker)itemStack.getValue()).underruns + "):" + item.getKey() + ", " + ((ItemStacker)itemStack.getValue()).itemStack.field_77993_c + " has " + ((ItemStacker)itemStack.getValue()).itemStack.field_77994_a);
            }
            ((TreeMap)item.getValue()).values().removeAll(toRemove);
        }
        System.out.println("Done");
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
        if (this.isPowered() && item.getItemStack().field_77994_a < 16) {
            this.addItemToItemStack(orientation, item.getItemStack().field_77993_c, item.getItemStack().func_77960_j(), item.getItemStack().field_77994_a);
            ((PipeTransportItems)this.transport).scheduleRemoval(item);
        } else {
            this.readjustSpeed(item);
        }
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.switched = nbttagcompound.func_74767_n("switched");
        this.toggled = nbttagcompound.func_74767_n("toggled");
        NBTTagList nbtItems = nbttagcompound.func_74761_m("items");
        for (int j = 0; j < nbtItems.func_74745_c(); ++j) {
            try {
                NBTTagCompound nbtTreeMap = (NBTTagCompound)nbtItems.func_74743_b(j);
                ForgeDirection orientation = ForgeDirection.values()[nbtTreeMap.func_74762_e("orientation")];
                NBTTagList nbtItemStacks = nbtTreeMap.func_74761_m("itemStacks");
                for (int k = 0; k < nbtItemStacks.func_74745_c(); ++k) {
                    try {
                        NBTTagCompound nbtItemStack = (NBTTagCompound)nbtItemStacks.func_74743_b(k);
                        Integer itemID = nbtItemStack.func_74762_e("itemID");
                        Integer dmgID = nbtItemStack.func_74762_e("dmgID");
                        Integer stackSize = nbtItemStack.func_74762_e("stackSize");
                        this.addItemToItemStack(orientation, itemID, dmgID, stackSize);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("switched", this.switched);
        nbttagcompound.func_74757_a("toggled", this.toggled);
        NBTTagList nbtItems = new NBTTagList();
        for (Map.Entry item : this.items.entrySet()) {
            NBTTagCompound nbtTreeMap = new NBTTagCompound();
            NBTTagList nbtItemStacks = new NBTTagList();
            for (Map.Entry itemStack : ((TreeMap)item.getValue()).entrySet()) {
                NBTTagCompound nbtItemStack = new NBTTagCompound();
                nbtItemStack.func_74768_a("itemID", ((Integer)((Pair)itemStack.getKey()).getFirst()).intValue());
                nbtItemStack.func_74768_a("dmgID", ((Integer)((Pair)itemStack.getKey()).getSecond()).intValue());
                nbtItemStack.func_74768_a("stackSize", ((ItemStacker)itemStack.getValue()).itemStack.field_77994_a);
                nbtItemStacks.func_74742_a((NBTBase)nbtItemStack);
            }
            nbtTreeMap.func_74768_a("orientation", ((ForgeDirection)item.getKey()).ordinal());
            nbtTreeMap.func_74782_a("itemStacks", (NBTBase)nbtItemStacks);
            nbtItems.func_74742_a((NBTBase)nbtTreeMap);
        }
        nbttagcompound.func_74782_a("items", (NBTBase)nbtItems);
    }

    public boolean isPowered() {
        return this.powered || this.switched || this.toggled;
    }

    public void updateRedstoneCurrent() {
        boolean lastPowered = this.powered;
        LinkedList<TileGenericPipe> neighbours = new LinkedList<TileGenericPipe>();
        neighbours.add(this.container);
        this.powered = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, o);
            pos.moveForwards(1.0);
            TileEntity tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isValid((Pipe)pipe.pipe)) continue;
            neighbours.add(pipe);
            if (!pipe.pipe.broadcastRedstone) continue;
            this.powered = true;
        }
        if (!this.powered) {
            this.powered = this.worldObj.func_72864_z(this.xCoord, this.yCoord, this.zCoord);
        }
        if (lastPowered != this.powered) {
            for (TileGenericPipe pipe : neighbours) {
                pipe.scheduleNeighborChange();
                pipe.func_70316_g();
            }
        }
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateRedstoneCurrent();
    }

    public LinkedList getActions() {
        LinkedList actions = super.getActions();
        actions.add(ABO.actionSwitchOnPipe);
        actions.add(ABO.actionToggleOnPipe);
        actions.add(ABO.actionToggleOffPipe);
        return actions;
    }

    protected void actionsActivated(HashMap actions) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        super.actionsActivated(actions);
        this.switched = false;
        for (Integer i : actions.keySet()) {
            if (!((Boolean)actions.get(i)).booleanValue()) continue;
            if (ActionManager.actions[i] instanceof ActionSwitchOnPipe) {
                this.switched = true;
                continue;
            }
            if (ActionManager.actions[i] instanceof ActionToggleOnPipe) {
                this.toggled = true;
                continue;
            }
            if (!(ActionManager.actions[i] instanceof ActionToggleOffPipe)) continue;
            this.toggled = false;
        }
        if (!(lastSwitched == this.switched && lastToggled == this.toggled || lastSwitched == this.switched || this.switched)) {
            this.toggled = false;
        }
    }

    public void actionActivated(IAction action) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        this.switched = false;
        if (action instanceof ActionToggleOnPipe) {
            this.toggled = true;
        } else if (action instanceof ActionToggleOffPipe) {
            this.toggled = false;
        }
        if (!(lastSwitched == this.switched && lastToggled == this.toggled || lastSwitched == this.switched || this.switched)) {
            this.toggled = false;
        }
    }

    public void updateEntity() {
        super.updateEntity();
        this.updateRedstoneCurrent();
        if (this.isPowered() && this.timeTracker.markTimeIfDelay(this.worldObj, 25L)) {
            this.doWork();
        }
    }

    public void readjustSpeed(IPipedItem item) {
        item.setSpeed(Math.min(Math.max(Utils.pipeNormalSpeed, item.getSpeed()) * 2.0f, Utils.pipeNormalSpeed * 30.0f));
    }

    public int getIconIndex(ForgeDirection direction) {
        if (this.worldObj != null) {
            return this.isPowered() ? this.onTexture : this.offTexture;
        }
        return this.offTexture;
    }

    private class Pair
    implements Comparable {
        private Object first;
        private Object second;

        public Pair(Object first, Object second) {
            this.first = first;
            this.second = second;
        }

        public int hashCode() {
            int hashFirst = this.first != null ? this.first.hashCode() : 0;
            int hashSecond = this.second != null ? this.second.hashCode() : 0;
            return (hashFirst + hashSecond) * hashSecond + hashFirst;
        }

        public boolean equals(Object other) {
            if (other instanceof Pair) {
                Pair otherPair = (Pair)other;
                return (this.first == otherPair.first || this.first != null && otherPair.first != null && this.first.equals(otherPair.first)) && (this.second == otherPair.second || this.second != null && otherPair.second != null && this.second.equals(otherPair.second));
            }
            return false;
        }

        public String toString() {
            return "(" + this.first + ", " + this.second + ")";
        }

        public Object getFirst() {
            return this.first;
        }

        public void setFirst(Object first) {
            this.first = first;
        }

        public Object getSecond() {
            return this.second;
        }

        public void setSecond(Object second) {
            this.second = second;
        }

        public int compareTo(Object other) {
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (this == other) {
                return 0;
            }
            if (!(other instanceof Pair)) {
                return -1;
            }
            Pair otherPair = (Pair)other;
            int comparison = ((Comparable)this.first).compareTo(otherPair.first);
            if (comparison != 0) {
                return comparison;
            }
            comparison = ((Comparable)this.second).compareTo(otherPair.second);
            if (comparison != 0) {
                return comparison;
            }
            assert (this.equals(other)) : "compareTo inconsistent with equals.";
            return 0;
        }
    }

    private class ItemStacker {
        public ItemStack itemStack;
        public int underruns;

        public ItemStacker(ItemStack iS) {
            this.itemStack = iS;
            this.underruns = 0;
        }
    }
}

