/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.liquids;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

class Neighbor {
    private final ITankContainer c;
    private final ForgeDirection o;

    public Neighbor(ITankContainer container, ForgeDirection orientation) {
        this.c = container;
        this.o = orientation;
    }

    public int getLiquidId() {
        ILiquidTank tank = this.getTank();
        if (tank == null) {
            return 0;
        }
        LiquidStack liquid = tank.getLiquid();
        return liquid != null ? liquid.itemID : 0;
    }

    public int getLiquidCapacity() {
        ILiquidTank tank = this.getTank();
        if (tank == null) {
            return 0;
        }
        return tank.getCapacity();
    }

    public int getLiquidAmount() {
        ILiquidTank tank = this.getTank();
        if (tank == null) {
            return 0;
        }
        LiquidStack liquid = tank.getLiquid();
        return liquid != null ? liquid.amount : 0;
    }

    public ILiquidTank getTank() {
        try {
            return this.c.getTanks(this.o.getOpposite())[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            try {
                return this.c.getTanks(ForgeDirection.UNKNOWN)[0];
            }
            catch (ArrayIndexOutOfBoundsException f) {
                return null;
            }
        }
    }

    public ITankContainer getTankEntity() {
        return this.c;
    }

    public ForgeDirection getOrientation() {
        return this.o;
    }
}

