/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.liquids;

import abo.ABO;
import abo.pipes.ABOPipe;
import abo.pipes.liquids.PipeLogicLiquidsDiamond;
import buildcraft.core.network.IClientState;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportLiquids;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidsDiamond
extends ABOPipe
implements IClientState {
    public PipeLiquidsDiamond(int itemID) {
        super((PipeTransport)new PipeTransportLiquids(), new PipeLogicLiquidsDiamond(), itemID);
        ((PipeTransportLiquids)this.transport).flowRate = (short)160;
        ((PipeTransportLiquids)this.transport).travelDelay = (short)2;
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().field_77993_c < Block.field_71973_m.length && Block.field_71973_m[entityplayer.func_71045_bC().field_77993_c] instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(this.worldObj, x, y, z, entityplayer)) {
            return true;
        }
        if (!this.worldObj.field_72995_K) {
            entityplayer.openGui((Object)ABO.instance, 100, this.worldObj, x, y, z);
        }
        return true;
    }

    public int getIconIndex(ForgeDirection direction) {
        switch (direction) {
            case UNKNOWN: {
                return 9;
            }
            case DOWN: {
                return 10;
            }
            case UP: {
                return 11;
            }
            case NORTH: {
                return 12;
            }
            case SOUTH: {
                return 13;
            }
            case WEST: {
                return 14;
            }
            case EAST: {
                return 15;
            }
        }
        throw new IllegalArgumentException("direction out of bounds");
    }

    public boolean outputOpen(ForgeDirection to) {
        if (!super.outputOpen(to)) {
            return false;
        }
        PipeTransportLiquids transportLiquids = (PipeTransportLiquids)this.transport;
        ILiquidTank[] tanks = transportLiquids.getTanks(ForgeDirection.UNKNOWN);
        if (tanks == null || tanks[ForgeDirection.UNKNOWN.ordinal()] == null || tanks[ForgeDirection.UNKNOWN.ordinal()].getLiquid() == null || tanks[ForgeDirection.UNKNOWN.ordinal()].getLiquid().amount == 0) {
            return true;
        }
        LiquidStack liquid = tanks[ForgeDirection.UNKNOWN.ordinal()].getLiquid();
        PipeLogicLiquidsDiamond logicDiamond = (PipeLogicLiquidsDiamond)this.logic;
        boolean[] validDirections = new boolean[ForgeDirection.values().length];
        boolean[] filteredDirections = new boolean[ForgeDirection.values().length];
        boolean filterForLiquid = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            validDirections[dir.ordinal()] = false;
            filteredDirections[dir.ordinal()] = false;
            if (!Utils.checkPipesConnections((TileEntity)this.container.getTile(dir), (TileEntity)this.container)) continue;
            for (int slot = 0; slot < 9; ++slot) {
                LiquidStack liquidStack = logicDiamond.liquidStacks[dir.ordinal() * 9 + slot];
                if (liquidStack == null) continue;
                filteredDirections[dir.ordinal()] = true;
                if (!liquid.isLiquidEqual(liquidStack)) continue;
                validDirections[dir.ordinal()] = true;
                filterForLiquid = true;
            }
        }
        if (filteredDirections[to.ordinal()] && validDirections[to.ordinal()]) {
            return true;
        }
        return !filterForLiquid && !filteredDirections[to.ordinal()];
    }

    public void writeData(DataOutputStream data) throws IOException {
        NBTTagCompound nbt = new NBTTagCompound();
        this.logic.writeToNBT(nbt);
        NBTBase.func_74731_a((NBTBase)nbt, (DataOutput)data);
    }

    public void readData(DataInputStream data) throws IOException {
        NBTBase nbt = NBTBase.func_74739_b((DataInput)data);
        if (nbt instanceof NBTTagCompound) {
            this.logic.readFromNBT((NBTTagCompound)nbt);
        }
    }
}

