/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.power;

import abo.ABO;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import abo.pipes.ABOPipe;
import buildcraft.api.core.Position;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicGold;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipePowerSwitch
extends ABOPipe
implements IActionReceptor {
    private final int unpoweredTexture = 23;
    private final int poweredTexture = 22;
    private boolean powered;
    private boolean switched;
    private boolean toggled;

    public PipePowerSwitch(int itemID) {
        super((PipeTransport)new PipeTransportPower(), (PipeLogic)new PipeLogicGold(), itemID);
        ((PipeTransportPower)this.transport).powerResistance = 0.001;
    }

    public int getIconIndex(ForgeDirection direction) {
        return this.isPowered() ? 22 : 23;
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe2 = null;
        if (tile instanceof TileGenericPipe) {
            pipe2 = ((TileGenericPipe)tile).pipe;
        }
        if (!this.isPowered()) {
            return false;
        }
        return (pipe2 == null || !(pipe2 instanceof PipePowerSwitch)) && super.canPipeConnect(tile, side);
    }

    public boolean isPowered() {
        return this.powered || this.switched || this.toggled;
    }

    public void updateRedstoneCurrent() {
        boolean lastPowered = this.powered;
        LinkedList<TileGenericPipe> neighbours = new LinkedList<TileGenericPipe>();
        neighbours.add(this.container);
        this.powered = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, o);
            pos.moveForwards(1.0);
            TileEntity tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isValid((Pipe)pipe.pipe)) continue;
            neighbours.add(pipe);
            if (!pipe.pipe.broadcastRedstone) continue;
            this.powered = true;
        }
        if (!this.powered) {
            this.powered = this.worldObj.func_72864_z(this.xCoord, this.yCoord, this.zCoord);
        }
        if (lastPowered != this.powered) {
            for (TileGenericPipe pipe : neighbours) {
                pipe.scheduleNeighborChange();
                pipe.func_70316_g();
            }
        }
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateRedstoneCurrent();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("switched", this.switched);
        nbttagcompound.func_74757_a("toggled", this.toggled);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.switched = nbttagcompound.func_74767_n("switched");
        this.toggled = nbttagcompound.func_74767_n("toggled");
    }

    public void updateEntity() {
        super.updateEntity();
        this.updateRedstoneCurrent();
    }

    public LinkedList getActions() {
        LinkedList actions = super.getActions();
        actions.add(ABO.actionSwitchOnPipe);
        actions.add(ABO.actionToggleOnPipe);
        actions.add(ABO.actionToggleOffPipe);
        return actions;
    }

    protected void actionsActivated(HashMap actions) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        super.actionsActivated(actions);
        this.switched = false;
        for (Integer i : actions.keySet()) {
            if (!((Boolean)actions.get(i)).booleanValue()) continue;
            if (ActionManager.actions[i] instanceof ActionSwitchOnPipe) {
                this.switched = true;
                continue;
            }
            if (ActionManager.actions[i] instanceof ActionToggleOnPipe) {
                this.toggled = true;
                continue;
            }
            if (!(ActionManager.actions[i] instanceof ActionToggleOffPipe)) continue;
            this.toggled = false;
        }
        if (lastSwitched != this.switched || lastToggled != this.toggled) {
            if (lastSwitched != this.switched && !this.switched) {
                this.toggled = false;
            }
            this.container.scheduleNeighborChange();
            this.updateNeighbors(true);
        }
    }

    public void actionActivated(IAction action) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        this.switched = false;
        if (action instanceof ActionToggleOnPipe) {
            this.toggled = true;
        } else if (action instanceof ActionToggleOffPipe) {
            this.toggled = false;
        }
        if (lastSwitched != this.switched || lastToggled != this.toggled) {
            if (lastSwitched != this.switched && !this.switched) {
                this.toggled = false;
            }
            this.container.scheduleNeighborChange();
            this.updateNeighbors(true);
        }
    }
}

