/*
 * Decompiled with CFR 0.152.
 */
package abo.triggers;

import abo.triggers.ABOTrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TriggerEngineSafe
extends ABOTrigger
implements ITriggerPipe {
    public TriggerEngineSafe(int id) {
        super(id);
    }

    private boolean checkEngine(TileEntity entity) {
        Engine engine = ((TileEngine)entity).engine;
        return engine == null || engine.getEnergyStage() == Engine.EnergyStage.Blue || engine.getEnergyStage() == Engine.EnergyStage.Green;
    }

    public String getDescription() {
        return "Engine Safe";
    }

    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        boolean result = true;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity entity = pipe.container.getTile(o);
            if (!(entity instanceof TileEngine) || this.checkEngine(entity)) continue;
            result = false;
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public int getIconIndex() {
        return 0;
    }
}

