/*
 * Decompiled with CFR 0.152.
 */
package abo.items;

import abo.items.ABOItem;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.GateVanilla;
import buildcraft.transport.Pipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemGateSettingsDuplicator
extends ABOItem {
    public ItemGateSettingsDuplicator(int itemID) {
        super(itemID);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77664_n();
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer entityPlayer, World worldObj, int x, int y, int z, int side, float var8, float var9, float var10) {
        if (worldObj.field_72995_K) {
            return super.onItemUseFirst(itemStack, entityPlayer, worldObj, x, y, z, side, var8, var9, var10);
        }
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)worldObj, (int)x, (int)y, (int)z);
        if (BlockGenericPipe.isValid((Pipe)pipe) && pipe.hasGate()) {
            if (itemStack.field_77990_d == null) {
                itemStack.field_77990_d = new NBTTagCompound();
            }
            if (entityPlayer.func_70093_af() && itemStack.field_77990_d.func_74764_b("GateSettings")) {
                GateSettings gS = GateSettings.createFromNBT(itemStack.field_77990_d);
                if (gS.kind == pipe.gate.kind && gS.isAutarchic == (pipe.gate instanceof GateVanilla && ((GateVanilla)pipe.gate).hasPulser())) {
                    for (int i = 0; i < 8; ++i) {
                        pipe.gate.actions[i] = (IAction)ActionManager.actions.get(((GateSettings)gS).slots[i].action);
                        pipe.gate.triggers[i] = (ITrigger)ActionManager.triggers.get(((GateSettings)gS).slots[i].trigger);
                        pipe.gate.triggerParameters[i] = new TriggerParameter();
                        pipe.gate.triggerParameters[i].set(((GateSettings)gS).slots[i].triggerParameter);
                    }
                    entityPlayer.func_70006_a(ChatMessageComponent.func_111066_d((String)StringUtils.localize((String)"gui.GateSettings.pasted")));
                }
            } else {
                GateSettings gS = new GateSettings(pipe.gate.kind);
                if (pipe.gate instanceof GateVanilla) {
                    gS.isAutarchic = ((GateVanilla)pipe.gate).hasPulser();
                }
                for (int i = 0; i < 8; ++i) {
                    if (pipe.gate.triggers[i] != null) {
                        ((GateSettings)gS).slots[i].trigger = pipe.gate.triggers[i].getUniqueTag();
                    }
                    if (pipe.gate.triggerParameters[i] != null) {
                        ((GateSettings)gS).slots[i].triggerParameter = pipe.gate.triggerParameters[i].getItemStack();
                    }
                    if (pipe.gate.actions[i] == null) continue;
                    ((GateSettings)gS).slots[i].action = pipe.gate.actions[i].getUniqueTag();
                }
                gS.writeToNBT(itemStack.field_77990_d);
                entityPlayer.func_70006_a(ChatMessageComponent.func_111066_d((String)StringUtils.localize((String)"gui.GateSettings.copied")));
            }
            return true;
        }
        return super.onItemUseFirst(itemStack, entityPlayer, worldObj, x, y, z, side, var8, var9, var10);
    }

    protected static class GateSettings {
        private final Gate.GateKind kind;
        private boolean isAutarchic;
        private final GateSlot[] slots;

        public GateSettings(Gate.GateKind kind) {
            this.kind = kind;
            this.slots = new GateSlot[8];
            for (int i = 0; i < 8; ++i) {
                this.slots[i] = new GateSlot();
            }
        }

        public void writeToNBT(NBTTagCompound stackTagCompound) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("gate", this.kind.ordinal());
            nbt.func_74757_a("hasPulser", this.isAutarchic);
            for (int i = 0; i < 8; ++i) {
                NBTTagCompound nbtslot = new NBTTagCompound();
                this.slots[i].writeToNBT(nbtslot);
                nbt.func_74766_a("Slot" + i, nbtslot);
            }
            stackTagCompound.func_74766_a("GateSettings", nbt);
        }

        public static GateSettings createFromNBT(NBTTagCompound stackTagCompound) {
            if (!stackTagCompound.func_74764_b("GateSettings")) {
                return null;
            }
            NBTTagCompound nbt = stackTagCompound.func_74775_l("GateSettings");
            GateSettings gS = new GateSettings(Gate.GateKind.values()[nbt.func_74762_e("gate")]);
            gS.isAutarchic = nbt.func_74767_n("hasPulser");
            for (int i = 0; i < 8; ++i) {
                gS.slots[i].readFromNBT(nbt.func_74775_l("Slot" + i));
            }
            return gS;
        }
    }

    static class GateSlot {
        String trigger = "";
        ItemStack triggerParameter = null;
        String action = "";

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74778_a("trigger", this.trigger);
            if (this.triggerParameter != null) {
                NBTTagCompound nbtparam = new NBTTagCompound();
                this.triggerParameter.func_77955_b(nbtparam);
                nbt.func_74766_a("triggerParameter", nbtparam);
            }
            nbt.func_74778_a("action", this.action);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            try {
                this.trigger = nbt.func_74779_i("trigger");
                this.triggerParameter = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("triggerParameter"));
                this.action = nbt.func_74779_i("action");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

