/*
 * Decompiled with CFR 0.152.
 */
package abo.network;

import abo.network.ABOPacket;
import abo.network.IFluidSlotChange;
import buildcraft.transport.TileGenericPipe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class PacketFluidSlotChange
extends ABOPacket {
    private int slot;
    private Fluid fluid;

    public PacketFluidSlotChange(int xCoord, int yCoord, int zCoord, int slot, Fluid fluid) {
        super(2, xCoord, yCoord, zCoord);
        this.slot = slot;
        this.fluid = fluid;
    }

    public PacketFluidSlotChange(DataInputStream data) throws IOException {
        this.readData(data);
    }

    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.slot);
        if (this.fluid == null) {
            data.writeShort(0);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("FluidName", this.fluid.getName());
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            data.writeShort(compressed.length);
            data.write(compressed);
        }
    }

    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.slot = data.readInt();
        short length = data.readShort();
        if (length == 0) {
            this.fluid = null;
        } else {
            byte[] compressed = new byte[length];
            data.readFully(compressed);
            NBTTagCompound nbt = CompressedStreamTools.func_74792_a((byte[])compressed);
            this.fluid = FluidRegistry.getFluid((String)nbt.func_74779_i("FluidName"));
        }
    }

    public void update(EntityPlayer player) {
        TileGenericPipe pipe = this.getPipe(player.field_70170_p, this.posX, this.posY, this.posZ);
        if (pipe == null || pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof IFluidSlotChange)) {
            return;
        }
        ((IFluidSlotChange)pipe.pipe).update(this.slot, this.fluid);
    }
}

