/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.fluids;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

class Neighbor {
    private final IFluidHandler c;
    private final ForgeDirection o;

    public Neighbor(IFluidHandler tile, ForgeDirection orientation) {
        this.c = tile;
        this.o = orientation;
    }

    public int getFluidId() {
        FluidTankInfo tank = this.getTank();
        if (tank == null) {
            return 0;
        }
        FluidStack fluid = tank.fluid;
        return fluid != null ? fluid.fluidID : 0;
    }

    public int getFluidCapacity() {
        FluidTankInfo tank = this.getTank();
        if (tank == null) {
            return 0;
        }
        return tank.capacity;
    }

    public int getFluidAmount() {
        FluidTankInfo tank = this.getTank();
        if (tank == null) {
            return 0;
        }
        FluidStack fluid = tank.fluid;
        return fluid != null ? fluid.amount : 0;
    }

    public FluidTankInfo getTank() {
        try {
            return this.c.getTankInfo(this.o.getOpposite())[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            try {
                return this.c.getTankInfo(ForgeDirection.UNKNOWN)[0];
            }
            catch (ArrayIndexOutOfBoundsException f) {
                return null;
            }
        }
    }

    public IFluidHandler getTankEntity() {
        return this.c;
    }

    public ForgeDirection getOrientation() {
        return this.o;
    }
}

