/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.items;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.inventory.InvUtils;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PipeItemsCompactorInventory {
    private final LinkedList<InventorySlot> inventoryContents = new LinkedList();

    public void addItemStack(World worldObj, ItemStack stack) {
        if (!stack.func_77985_e() || stack.field_77994_a == stack.func_77976_d()) {
            this.inventoryContents.add(new InventorySlot(worldObj, stack));
            return;
        }
        for (InventorySlot slot : this.inventoryContents) {
            stack = slot.appendToStack(worldObj, stack);
            if (stack != null) continue;
            return;
        }
        this.inventoryContents.add(new InventorySlot(worldObj, stack));
    }

    public void dropContents(World worldObj, int xCoord, int yCoord, int zCoord) {
        for (InventorySlot inventorySlot : this.inventoryContents) {
            InvUtils.dropItems((World)worldObj, (ItemStack)inventorySlot.getItemStack(), (int)xCoord, (int)yCoord, (int)zCoord);
        }
        this.inventoryContents.clear();
    }

    public ItemStack findItemStackToRemove(World worldObj, int stackSize, int unchangedSince) {
        Iterator inventorySlots = this.inventoryContents.iterator();
        while (inventorySlots.hasNext()) {
            InventorySlot inventorySlot = (InventorySlot)inventorySlots.next();
            if (inventorySlot.getItemStack().field_77994_a < stackSize && !inventorySlot.isItemStackFull() && !inventorySlot.isNotModifiedSince(worldObj, unchangedSince)) continue;
            inventorySlots.remove();
            return inventorySlot.getItemStack();
        }
        return null;
    }

    public void readFromNBT(World worldObj, NBTTagCompound nbtItemStacks) {
        int itemCount = nbtItemStacks.func_74762_e("itemCount");
        for (int itemStackNr = 0; itemStackNr < itemCount; ++itemStackNr) {
            try {
                NBTTagCompound nbtItemStack = (NBTTagCompound)nbtItemStacks.func_74781_a("itemStack" + itemStackNr);
                this.inventoryContents.add(new InventorySlot(worldObj, ItemStack.func_77949_a((NBTTagCompound)nbtItemStack)));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbtItemStacks) {
        int itemStackNr = 0;
        for (InventorySlot inventorySlot : this.inventoryContents) {
            NBTTagCompound nbtItemStack = new NBTTagCompound();
            inventorySlot.getItemStack().func_77955_b(nbtItemStack);
            nbtItemStacks.func_74782_a("itemStack" + itemStackNr++, (NBTBase)nbtItemStack);
        }
        nbtItemStacks.func_74768_a("itemCount", itemStackNr);
    }

    private class InventorySlot {
        private final SafeTimeTracker timeTracker = new SafeTimeTracker();
        private final ItemStack itemStack;

        InventorySlot(World worldObj, ItemStack stack) {
            this.itemStack = stack;
            this.markModifed(worldObj);
        }

        public void markModifed(World worldObj) {
            if (worldObj != null) {
                this.timeTracker.markTime(worldObj);
            }
        }

        public boolean isNotModifiedSince(World worldObj, int unchangedSince) {
            if (worldObj != null) {
                return this.timeTracker.markTimeIfDelay(worldObj, (long)unchangedSince);
            }
            return true;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public boolean isItemStackFull() {
            return !this.itemStack.func_77985_e() || this.itemStack.field_77994_a == this.itemStack.func_77976_d();
        }

        public ItemStack appendToStack(World worldObj, ItemStack stack) {
            if (this.itemStack.func_77969_a(stack)) {
                int stackSize = this.itemStack.field_77994_a + stack.field_77994_a;
                if (stackSize < this.itemStack.func_77976_d()) {
                    this.itemStack.field_77994_a = stackSize;
                    this.markModifed(worldObj);
                    return null;
                }
                this.itemStack.field_77994_a = stack.func_77976_d();
                stack.field_77994_a = stackSize - stack.func_77976_d();
                this.markModifed(worldObj);
            }
            return stack;
        }
    }
}

