/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.power;

import abo.ABO;
import abo.network.IYesNoChange;
import abo.pipes.ABOPipe;
import buildcraft.core.network.IClientState;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeTransportPower;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipePowerDistribution
extends ABOPipe<PipeTransportPower>
implements IClientState,
IYesNoChange {
    public final boolean[] connectionMatrix = new boolean[]{true, true, true, true, true, true};
    public boolean isDirty = true;

    public PipePowerDistribution(int itemID) {
        super(new PipeTransportPower(), itemID);
        PipeTransportPower cfr_ignored_0 = (PipeTransportPower)this.transport;
        PipeTransportPower.powerCapacities.put(PipePowerDistribution.class, 1024);
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().field_77993_c < Block.field_71973_m.length && Block.field_71973_m[entityplayer.func_71045_bC().field_77993_c] instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(entityplayer)) {
            return true;
        }
        if (!this.container.field_70331_k.field_72995_K) {
            entityplayer.openGui((Object)ABO.instance, 110, this.container.field_70331_k, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        }
        return true;
    }

    @Override
    public void update(int slot, boolean state) {
        if (this.connectionMatrix[slot] != state) {
            this.connectionMatrix[slot] = state;
            this.isDirty = true;
            this.updateEntity();
        }
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.isDirty) {
            this.container.scheduleNeighborChange();
            this.updateNeighbors(true);
            this.isDirty = false;
        }
    }

    public int getIconIndex(ForgeDirection direction) {
        switch (direction) {
            case UNKNOWN: {
                return 24;
            }
            case DOWN: {
                return 25;
            }
            case UP: {
                return 26;
            }
            case NORTH: {
                return 27;
            }
            case SOUTH: {
                return 28;
            }
            case WEST: {
                return 29;
            }
            case EAST: {
                return 30;
            }
        }
        throw new IllegalArgumentException("direction out of bounds");
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        return this.connectionMatrix[side.ordinal()] && super.canPipeConnect(tile, side);
    }

    public void writeData(DataOutputStream data) throws IOException {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < 6; ++i) {
            nbt.func_74757_a("connectionMatrix[" + i + "]", this.connectionMatrix[i]);
        }
        NBTBase.func_74731_a((NBTBase)nbt, (DataOutput)data);
    }

    public void readData(DataInputStream data) throws IOException {
        NBTBase nbt = NBTBase.func_74739_b((DataInput)data);
        if (nbt instanceof NBTTagCompound) {
            for (int i = 0; i < 6; ++i) {
                this.connectionMatrix[i] = ((NBTTagCompound)nbt).func_74767_n("connectionMatrix[" + i + "]");
            }
        }
    }
}

