/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.power;

import abo.pipes.ABOPipe;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogicIron;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipePowerIron
extends ABOPipe<PipeTransportPower>
implements IPipeTransportPowerHook {
    private final int baseTexture = 31;
    private final int sideTexture = 32;
    private final PipeLogicIron logic = new PipeLogicIron(this){

        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof TileGenericPipe) {
                Pipe otherPipe = ((TileGenericPipe)tile).pipe;
                if (otherPipe instanceof PipePowerWood || otherPipe instanceof PipeStructureCobblestone) {
                    return false;
                }
                return otherPipe.transport instanceof PipeTransportPower;
            }
            return tile instanceof IPowerReceptor;
        }
    };

    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    public void onNeighborBlockChange(int blockId) {
        this.logic.switchOnRedstone();
        super.onNeighborBlockChange(blockId);
    }

    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        super.onBlockPlaced();
    }

    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    public PipePowerIron(int itemID) {
        super(new PipeTransportPower(), itemID);
        PipeTransportPower cfr_ignored_0 = (PipeTransportPower)this.transport;
        PipeTransportPower.powerCapacities.put(PipePowerIron.class, 1024);
        ((PipeTransportPower)this.transport).initFromPipe(((Object)((Object)this)).getClass());
    }

    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 31;
        }
        int metadata = this.container.func_70322_n();
        if (metadata == direction.ordinal()) {
            return 31;
        }
        return 32;
    }

    public float receiveEnergy(ForgeDirection from, float val) {
        int metadata = this.container.func_70322_n();
        if (metadata != from.ordinal() && (double)val > 0.0) {
            int n = from.ordinal();
            ((PipeTransportPower)this.transport).internalNextPower[n] = ((PipeTransportPower)this.transport).internalNextPower[n] + val;
            if (((PipeTransportPower)this.transport).internalNextPower[from.ordinal()] > (float)((PipeTransportPower)this.transport).maxPower) {
                val = ((PipeTransportPower)this.transport).internalNextPower[from.ordinal()] - (float)((PipeTransportPower)this.transport).maxPower;
                ((PipeTransportPower)this.transport).internalNextPower[from.ordinal()] = ((PipeTransportPower)this.transport).maxPower;
            }
        }
        return val;
    }

    public float requestEnergy(ForgeDirection from, float amount) {
        int metadata = this.container.func_70322_n();
        if (metadata == from.ordinal()) {
            return amount;
        }
        return 0.0f;
    }
}

