/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.items;

import abo.ABO;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.PipeConnectionBans;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipeItemsWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsExtraction
extends PipeItemsWood
implements IPowerReceptor,
IPipeTransportItemsHook {
    private final int standardIconIndex = 3;
    private final int solidIconIndex = 4;

    public PipeItemsExtraction(int itemID) {
        super(itemID);
        PipeConnectionBans.banConnection((Class[])new Class[]{PipeItemsExtraction.class, PipeItemsWood.class});
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return ABO.instance.pipeIconProvider;
    }

    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 3;
        }
        int metadata = this.container.func_70322_n();
        if (metadata == direction.ordinal()) {
            return 4;
        }
        return 3;
    }

    public LinkedList<ForgeDirection> filterPossibleMovements(LinkedList<ForgeDirection> possibleOrientations, Position pos, TravelingItem item) {
        LinkedList<ForgeDirection> nonPipesList = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> pipesList = new LinkedList<ForgeDirection>();
        item.blacklist.add(item.input.getOpposite());
        for (ForgeDirection o : possibleOrientations) {
            if (item.blacklist.contains(o) || !this.container.pipe.outputOpen(o) || !((PipeTransportItems)this.transport).canReceivePipeObjects(o, item)) continue;
            TileEntity entity = this.container.getTile(o);
            if (entity instanceof IPipeTile) {
                pipesList.add(o);
                continue;
            }
            nonPipesList.add(o);
        }
        if (!pipesList.isEmpty()) {
            return pipesList;
        }
        return nonPipesList;
    }

    public void entityEntered(TravelingItem item, ForgeDirection orientation) {
    }

    public void readjustSpeed(TravelingItem item) {
        ((PipeTransportItems)this.transport).defaultReajustSpeed(item);
    }
}

