/*
 * Decompiled with CFR 0.152.
 */
package arg;

import arg.RecipeHelper;
import arg.RenderRecipe;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;

@Mod(modid="Advanced-Recipe-Generator", name="Advanced-Recipe-Generator", version="0.0.3")
public class ARG {
    public static final String NAME = "Advanced-Recipe-Generator";
    public static final String VERSION = "0.0.3";
    @Mod.Instance(value="Advanced-Recipe-Generator")
    public static ARG instance;
    public static Logger argLog;
    public static int[] mapLoaded;
    public static boolean mapGenerated;

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        argLog.setParent(FMLLog.getLogger());
        argLog.info("Starting Advanced-Recipe-Generator #29 0.0.3 (Built for Minecraft/Forge 1.6.4-9.11.1.964");
        argLog.info("Copyright (c) Flow86, 2012-2014");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @ForgeSubscribe(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void createRecipeImages(TextureStitchEvent.Post evt) {
        int n = evt.map.textureType;
        mapLoaded[n] = mapLoaded[n] + 1;
        if (mapLoaded[0] > 0 && mapLoaded[0] == mapLoaded[1]) {
            if (mapGenerated) {
                return;
            }
            mapGenerated = true;
            argLog.info("Generating Recipes ...");
            TextureManager tm = Minecraft.getMinecraft().getTextureManager();
            Map mapTextureObjects = (Map)ObfuscationReflectionHelper.getPrivateValue(TextureManager.class, (Object)tm, (String[])new String[]{"mapTextureObjects", "field_110585_a"});
            HashMap new_mapTextureObjects = Maps.newHashMap();
            new_mapTextureObjects.putAll(mapTextureObjects);
            ObfuscationReflectionHelper.setPrivateValue(TextureManager.class, (Object)tm, (Object)new_mapTextureObjects, (String[])new String[]{"mapTextureObjects", "field_110585_a"});
            for (Object orecipe : CraftingManager.getInstance().getRecipeList()) {
                IRecipe irecipe = (IRecipe)orecipe;
                if (irecipe instanceof RecipesArmorDyes || irecipe instanceof RecipeFireworks || irecipe instanceof RecipesMapCloning) continue;
                if (irecipe.getRecipeOutput() == null) {
                    System.out.println("Skip recipe without output: " + irecipe.getClass().getSimpleName());
                    continue;
                }
                RenderRecipe render = new RenderRecipe(irecipe.getRecipeOutput().getDisplayName());
                ItemStack[] recipeInput = null;
                try {
                    recipeInput = RecipeHelper.getRecipeArray(irecipe);
                    if (recipeInput == null) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                GameRegistry.UniqueIdentifier identifier = null;
                identifier = this.getUniqueIdentifier(irecipe.getRecipeOutput());
                for (int recipe = 0; identifier == null && recipeInput != null && recipe < recipeInput.length; ++recipe) {
                    ItemStack input = recipeInput[recipe];
                    identifier = this.getUniqueIdentifier(input);
                }
                String subFolder = "vanilla";
                if (identifier != null) {
                    subFolder = identifier.modId;
                }
                try {
                    for (int i = 0; i < recipeInput.length - 1; ++i) {
                        render.getCraftingContainer().craftMatrix.setInventorySlotContents(i, recipeInput[i + 1]);
                    }
                    render.getCraftingContainer().craftResult.setInventorySlotContents(0, recipeInput[0]);
                    render.draw(subFolder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ObfuscationReflectionHelper.setPrivateValue(TextureManager.class, (Object)tm, (Object)mapTextureObjects, (String[])new String[]{"mapTextureObjects", "field_110585_a"});
            argLog.info("Finished Generation of Recipes in " + Minecraft.getMinecraft().mcDataDir + "/recipes/");
        }
    }

    private GameRegistry.UniqueIdentifier getUniqueIdentifier(ItemStack itemStack) {
        if (itemStack == null || itemStack.getItem() == null) {
            return null;
        }
        if (itemStack.getItem() instanceof ItemBlock) {
            int blockId = ((ItemBlock)itemStack.getItem()).getBlockID();
            Block block = Block.blocksList[blockId];
            return GameRegistry.findUniqueIdentifierFor((Block)block);
        }
        return GameRegistry.findUniqueIdentifierFor((Item)itemStack.getItem());
    }

    static {
        argLog = Logger.getLogger(NAME);
        mapLoaded = new int[]{0, 0};
        mapGenerated = false;
    }
}

